/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.datasource.db;

import com.mckoi.database.TableDataConglomerate;
import com.mckoi.database.TransactionSystem;
import com.mckoi.database.control.DBConfig;
import com.mckoi.database.control.DBController;
import com.mckoi.database.control.DBSystem;
import com.mckoi.database.control.DefaultDBConfig;
import com.mckoi.util.UserTerminal;
import de.willuhn.datasource.db.DBServiceImpl;
import de.willuhn.datasource.rmi.DBService;
import de.willuhn.logging.Logger;
import de.willuhn.sql.CheckSum;
import de.willuhn.sql.ScriptExecutor;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;

public class EmbeddedDatabase {
    private File path = null;
    private DefaultDBConfig config = null;
    private DBController control = null;
    private DBService db = null;
    private String username = null;
    private String password = null;
    private static String defaultConfig = "database_path=.\nlog_path=./log\nroot_path=configuration\njdbc_server_port=9157\nignore_case_for_identifiers=disabled\ndata_cache_size=4194304\nmax_cache_entry_size=8192\nmaximum_worker_threads=4\ndebug_log_file=debug.log\ntransaction_error_on_dirty_select=disabled\ndebug_level=30\n";

    public EmbeddedDatabase(String path, String username, String password) throws Exception {
        if (username == null || username.length() == 0) {
            throw new Exception("please enter a username");
        }
        if (password == null || password.length() == 0) {
            throw new Exception("please enter a password");
        }
        if (path == null || path.length() == 0) {
            throw new IOException("please enter a path");
        }
        this.path = new File(path);
        this.username = username;
        this.password = password;
        if (!this.path.exists()) {
            Logger.info((String)("creating directory " + this.path.getAbsolutePath()));
            this.path.mkdir();
        }
        if (!this.path.canWrite()) {
            throw new IOException("write permission failed in " + this.path.getAbsolutePath());
        }
        this.config = new DefaultDBConfig(this.path);
        this.config.setDatabasePath(this.path.getAbsolutePath());
        this.config.setLogPath(this.path.getAbsolutePath() + "/log");
        this.control = DBController.getDefault();
        if (!this.exists()) {
            this.create();
        }
    }

    public synchronized boolean exists() {
        return this.control.databaseExists((DBConfig)this.config);
    }

    public synchronized void create() throws IOException {
        if (this.exists()) {
            return;
        }
        Logger.info((String)"creating database config file");
        try {
            FileOutputStream fos = new FileOutputStream(this.path.getAbsolutePath() + "/db.conf");
            fos.write(defaultConfig.getBytes());
            fos.close();
        }
        catch (IOException e) {
            Logger.error((String)"failed", (Throwable)e);
            throw new IOException(e.getMessage());
        }
        try {
            DBSystem session = null;
            Logger.info((String)"creating database");
            session = this.control.createDatabase((DBConfig)this.config, this.username, this.password);
            session.close();
        }
        catch (Error error) {
            Logger.error((String)"error while creating database", (Throwable)error);
            throw new IOException(error.getMessage());
        }
        catch (Exception e) {
            Logger.error((String)"error while creating database", (Throwable)e);
            throw new IOException(e.getMessage());
        }
    }

    public synchronized void delete() {
        Logger.warn((String)("deleting database in " + this.path.getAbsolutePath()));
        if (!this.exists()) {
            Logger.warn((String)"database does not exist, skipping");
            return;
        }
        DBSystem system = this.control.startDatabase((DBConfig)this.config);
        system.setDeleteOnClose(true);
        system.close();
        Logger.warn((String)"database deleted");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeSQLScript(File file) throws IOException, SQLException {
        if (file == null) {
            throw new NullPointerException("sql file not given");
        }
        Logger.debug((String)("executing " + file.getAbsolutePath()));
        if (!file.canRead() || !file.exists()) {
            throw new IOException("SQL file does not exist or is not readable");
        }
        Connection conn = null;
        DBSystem session = null;
        InputStreamReader reader = null;
        try {
            session = this.control.startDatabase((DBConfig)this.config);
            conn = session.getConnection(this.username, this.password);
            reader = new FileReader(file);
            Logger.info((String)("executing sql commands from " + file.getAbsolutePath()));
            ScriptExecutor.execute((Reader)reader, (Connection)conn);
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (Exception e3) {
                Logger.error((String)("error while closing file " + file.getAbsolutePath()), (Throwable)e3);
            }
            try {
                if (conn != null) {
                    conn.close();
                }
            }
            catch (Exception e3) {
                Logger.error((String)"error while closing connection", (Throwable)e3);
            }
            try {
                if (session != null) {
                    session.close();
                }
            }
            catch (Exception e4) {
                Logger.error((String)"error while closing session", (Throwable)e4);
            }
        }
    }

    public File getPath() {
        return this.path;
    }

    public DBService getDBService() throws RemoteException {
        if (this.db != null) {
            return this.db;
        }
        this.db = new DBServiceImpl("com.mckoi.JDBCDriver", ":jdbc:mckoi:local://" + this.path.getAbsolutePath() + "/db.conf?user=" + this.username + "&password=" + this.password);
        return this.db;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getMD5Sum() throws Exception {
        Connection conn = null;
        try {
            conn = this.getConnection();
            String string = CheckSum.md5((Connection)conn, null, (String)"APP");
            return string;
        }
        finally {
            try {
                if (conn != null) {
                    conn.close();
                }
            }
            catch (Exception e2) {
                Logger.error((String)"error while closing connection", (Throwable)e2);
            }
        }
    }

    public void repair(UserTerminal terminal) {
        TransactionSystem system = new TransactionSystem();
        DefaultDBConfig config = new DefaultDBConfig();
        config.setDatabasePath(this.path.getAbsolutePath());
        config.setLogPath("");
        config.setMinimumDebugLevel(50000);
        config.setValue("do_not_use_nio_api", "enabled");
        system.setDebugOutput((Writer)new StringWriter());
        system.init((DBConfig)config);
        TableDataConglomerate conglomerate = new TableDataConglomerate(system, system.storeSystem());
        conglomerate.fix("DefaultDatabase", terminal);
        system.dispose();
    }

    public Connection getConnection() throws Exception {
        Class.forName("com.mckoi.JDBCDriver");
        return DriverManager.getConnection(":jdbc:mckoi:local://" + this.path.getAbsolutePath() + "/db.conf?user=" + this.username + "&password=" + this.password);
    }
}

